/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.workflow.VWWorkflowClassTreeNode;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

class VWWorkflowHierarchyTreeRenderer
extends JLabel
implements TreeCellRenderer {
    private ImageIcon m_rootIcon = null;
    private ImageIcon m_localWorkClassIcon = null;
    private ImageIcon m_serverWorkClassIcon = null;

    public VWWorkflowHierarchyTreeRenderer() {
        this.setOpaque(true);
        this.m_rootIcon = VWImageLoader.createImageIcon("pe.gif");
        this.m_localWorkClassIcon = VWImageLoader.createImageIcon("workflowCollection.gif");
        this.m_serverWorkClassIcon = VWImageLoader.createImageIcon("server.gif");
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int row, boolean bHasFocus) {
        if (value != null) {
            if (value instanceof VWWorkflowClassTreeNode) {
                VWWorkflowClassTreeNode node = (VWWorkflowClassTreeNode)value;
                if (node.getWasRetrievedFromServer()) {
                    this.setIcon(this.m_serverWorkClassIcon);
                } else {
                    this.setIcon(this.m_localWorkClassIcon);
                }
                this.setText(node.getName());
            } else if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                this.setIcon(this.m_rootIcon);
                this.setText(node.toString());
            }
            if (bSelected) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(tree.getBackground());
                this.setForeground(tree.getForeground());
            }
        }
        return this;
    }
}

